Attribute VB_Name = "Networking"
Option Explicit

'----------------------------------------------------------
'  Myriad
'  Networking Module
'----------------------------------------------------------
'  Copyright  2005 Eric Naeseth.
'  March 8, 2005
'----------------------------------------------------------

'----------------------------------------------------------
'  DLL Function Declarations
'----------------------------------------------------------
Public Declare Function myriad_net_init Lib "myriadhelp.dll" _
    (ByVal EventProc As Long) As Long
Public Declare Sub myriad_net_cleanup Lib "myriadhelp.dll" ()

Public Declare Function myriad_net_connect Lib "myriadhelp.dll" _
    (ByVal Host As String, ByVal Port As Long, ByRef Socket As Long) _
    As Long
Public Declare Function myriad_net_disconnect Lib "myriadhelp.dll" _
    (ByVal Socket As Long) As Long
Public Declare Function myriad_net_recv Lib "myriadhelp.dll" _
    (ByVal Socket As Long, ByVal Buf As String, ByVal Length As Long) _
    As Long
Public Declare Function myriad_net_send Lib "myriadhelp.dll" _
    (ByVal Socket As Long, ByVal Buf As String, ByVal Length As Long) _
    As Long
Public Declare Function myriad_start_event_loop Lib "myriadhelp.dll" _
    () As Long
Public Declare Sub myriad_stop_event_loop Lib "myriadhelp.dll" ()


'----------------------------------------------------------
'  Socket Identifiers
'----------------------------------------------------------
Public Bnet_Socket As Long, BNLS_Socket As Long, MCP_Socket As Long

'----------------------------------------------------------
'  Event Types
'----------------------------------------------------------
Private Const NET_EVENT_CONNECTING As Long = &H0
Private Const NET_EVENT_CONNECTED As Long = &H1
Private Const NET_EVENT_DISCONNECTED As Long = &H2
Private Const NET_EVENT_DATA As Long = &H3
Private Const NET_EVENT_ERROR As Long = &H4
Private Const NET_EVENT_INTERROR As Long = &H5

'----------------------------------------------------------
'  Connect Error Types
'----------------------------------------------------------
Public Const NET_CONERR_PORT As Long = &H1
Public Const NET_CONERR_RESOLVE As Long = &H2
Public Const NET_CONERR_MEMORY As Long = &H3
Public Const NET_CONERR_SOCKET As Long = &H4
Public Const NET_CONERR_THREAD As Long = &H5
Public Const NET_CONERR_NONBLOCK As Long = &H6
Public Const NET_CONERR_CONNECT As Long = &H7
Public Const NET_CONERR_EVENT As Long = &H8


'----------------------------------------------------------
'  Internal Error Types
'----------------------------------------------------------
Private Const NET_ERR_IOCTL As Long = &H1
Private Const NET_ERR_WAIT As Long = &H2


'----------------------------------------------------------
'  Event Listener
'----------------------------------------------------------
Public Sub net_event_proc(ByVal Sock As Long, ByVal EventType As Long, _
ByVal Extra As Long)
On Error GoTo Proc_Error
    Dim Buf As String
    'MsgBox "net_event_proc(" & Sock & ", " & EventType & ", " & Extra & ")", vbInformation, GetVersion()
    Select Case EventType
        Case NET_EVENT_CONNECTING
            Select Case Sock
                Case Bnet_Socket
                    BotEvent vbNullString, evConnecting
                Case BNLS_Socket
                    BotEvent vbNullString, evBnlsConnecting
                Case MCP_Socket
                    BotEvent vbNullString, evRealmConnecting
                Case Else
                    LogEvent "Received connecting event for unknown socket.", etAlwaysError
            End Select
        Case NET_EVENT_CONNECTED
            Select Case Sock
                Case Bnet_Socket
                    'BotEvent vbNullString, evConnect
                    Bot.SocketEvent sConnect, sBattleNet
                Case BNLS_Socket
                    'BotEvent vbNullString, evBnlsConnect
                    Bot.SocketEvent sConnect, sBNLS
                Case MCP_Socket
                    'BotEvent vbNullString, evRealmConnect
                    Bot.SocketEvent sConnect, sMCP
                Case Else
                    LogEvent "Received connect event for unknown socket.", etAlwaysError
            End Select
        Case NET_EVENT_DISCONNECTED
            Select Case Sock
                Case Bnet_Socket
                    'BotEvent vbNullString, evDisconnect
                    Bot.SocketEvent sDisconnect, sBattleNet
                Case BNLS_Socket
                    'BotEvent vbNullString, evBnlsDisconnect
                    Bot.SocketEvent sDisconnect, sBNLS
                Case MCP_Socket
                    'BotEvent vbNullString, evRealmDisconnect
                    Bot.SocketEvent sDisconnect, sMCP
                Case Else
                    LogEvent "Received disconnect event for unknown socket.", etAlwaysError
            End Select
        Case NET_EVENT_ERROR
            Select Case Sock
                Case Bnet_Socket
                    Bot.SocketEvent sError, sBattleNet, GetWSAErrorString(Extra), Extra
                Case BNLS_Socket
                    Bot.SocketEvent sError, sBNLS, GetWSAErrorString(Extra), Extra
                Case MCP_Socket
                    Bot.SocketEvent sError, sMCP, GetWSAErrorString(Extra), Extra
                Case Else
                    LogEvent "Received error event for unknown socket.", etAlwaysError
            End Select
        Case NET_EVENT_DATA
            Buf = String$(Extra, vbNullChar)
            If (myriad_net_recv(Sock, Buf, Extra) < 0) Then
                Select Case Sock
                    Case Bnet_Socket
                        Bot.SocketEvent sError, sBattleNet, "Could not retrieve incoming data", 2
                    Case BNLS_Socket
                        Bot.SocketEvent sError, sBNLS, "Could not retrieve incoming data", 2
                    Case MCP_Socket
                        Bot.SocketEvent sError, sMCP, "Could not retrieve incoming data", 2
                    Case Else
                        LogEvent "Could not retrieve incoming data on unknown socket.", etAlwaysError
                End Select
            End If
            
            Select Case Sock
                Case Bnet_Socket
                    Bot.SocketEvent sData, sBattleNet, Buf, Extra
                Case BNLS_Socket
                    Bot.SocketEvent sData, sBNLS, Buf, Extra
                Case MCP_Socket
                    Bot.SocketEvent sData, sMCP, Buf, Extra
                Case Else
                    LogEvent "Received error event for unknown socket.", etAlwaysError
            End Select
        Case NET_EVENT_INTERROR
            Select Case Extra
                Case NET_ERR_WAIT
                    BotEvent vbNullString, evConError, "Event wait error."
            End Select
        'Case &H6
        '    BotEvent vbNullString, evConMsg, Extra
        Case Else
            LogEvent "Received unknown socket event.", etAlwaysError
    End Select
    Exit Sub
Proc_Error:
    AddC "Event proc error: " & Err.Description & " (#" & Err.Number & ")", _
        vbRed
End Sub

